@echo off

title CPU Broadwell Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin

if not exist bdw (echo Error! Folder HSW not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU Skylake (LGA1151)
echo.
echo 	10 Version 10 Date 04-22-2015
echo 	16 Version 16 Date 05-13-2015
echo 	1A Version 1A Date 05-28-2015
echo 	1C Version 1C Date 06-02-2015
echo 	1E Version 1E Date 06-10-2015
echo 	20 Version 20 Date 06-18-2015
echo 	24 Version 24 Date 07-01-2015
echo 	2E Version 2E Date 07-21-2015
echo 	30 Version 30 Date 07-29-2015
echo 	32 Version 32 Date 08-04-2015
echo 	34 Version 34 Date 08-08-2015
echo 	3A Version 3A Date 08-23-2015
echo 	4A Version 4A Date 09-18-2015
echo 	4C Version 4C Date 10-01-2015
echo 	50 Version 50 Date 10-12-2015
echo 	56 Version 56 Date 10-24-2015
echo 	5C Version 5C Date 11-06-2015
echo 	6A Version 6A Date 12-14-2015
echo 	74 Version 74 Date 01-05-2016 - Last for non-K overclocking
echo 	76 Version 76 Date 01-07-2016
echo 	7C Version 7C Date 01-31-2016
echo 	82 Version 82 Date 02-21-2016
echo 	84 Version 84 Date 03-01-2016
echo 	88 Version 88 Date 03-16-2016
echo 	0  Exit
echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1
if /I %ec%==10 (set mc=skl\cpu000506E3_plat36_ver00000010_date#22-04-2015.bin) && goto start
if /I %ec%==16 (set mc=skl\cpu000506E3_plat36_ver00000016_date#13-05-2015.bin) && goto start
if /I %ec%==1A (set mc=skl\cpu000506E3_plat36_ver0000001A_date#28-05-2015.bin) && goto start
if /I %ec%==1C (set mc=skl\cpu000506E3_plat36_ver0000001C_date#02-06-2015.bin) && goto start
if /I %ec%==1E (set mc=skl\cpu000506E3_plat36_ver0000001E_date#10-06-2015.bin) && goto start
if /I %ec%==20 (set mc=skl\cpu000506E3_plat36_ver00000020_date#18-06-2015.bin) && goto start
if /I %ec%==24 (set mc=skl\cpu000506E3_plat36_ver00000024_date#01-07-2015.bin) && goto start
if /I %ec%==2E (set mc=skl\cpu000506E3_plat36_ver0000002E_date#21-07-2015.bin) && goto start
if /I %ec%==30 (set mc=skl\cpu000506E3_plat36_ver00000030_date#29-07-2015.bin) && goto start
if /I %ec%==32 (set mc=skl\cpu000506E3_plat36_ver00000032_date#04-08-2015.bin) && goto start
if /I %ec%==34 (set mc=skl\cpu000506E3_plat36_ver00000034_date#08-08-2015.bin) && goto start
if /I %ec%==3A (set mc=skl\cpu000506E3_plat36_ver0000003A_date#23-08-2015.bin) && goto start
if /I %ec%==4A (set mc=skl\cpu000506E3_plat36_ver0000004A_date#18-09-2015.bin) && goto start
if /I %ec%==4C (set mc=skl\cpu000506E3_plat36_ver0000004C_date#01-10-2015.bin) && goto start
if /I %ec%==50 (set mc=skl\cpu000506E3_plat36_ver00000050_date#12-10-2015.bin) && goto start
if /I %ec%==56 (set mc=skl\cpu000506E3_plat36_ver00000056_date#24-10-2015.bin) && goto start
if /I %ec%==5C (set mc=skl\cpu000506E3_plat36_ver0000005C_date#06-11-2015.bin) && goto start
if /I %ec%==6A (set mc=skl\cpu000506E3_plat36_ver0000006A_date#14-12-2015.bin) && goto start
if /I %ec%==74 (set mc=skl\cpu000506E3_plat36_ver00000074_date#05-01-2016.bin) && goto start
if /I %ec%==76 (set mc=skl\cpu000506E3_plat36_ver00000076_date#07-01-2016.bin) && goto start
if /I %ec%==7C (set mc=skl\cpu000506E3_plat36_ver0000007C_date#31-01-2016.bin) && goto start
if /I %ec%==82 (set mc=skl\cpu000506E3_plat36_ver00000082_date#21-02-2016.bin) && goto start
if /I %ec%==84 (set mc=skl\cpu000506E3_plat36_ver00000084_date#01-03-2016.bin) && goto start
if /I %ec%==88 (set mc=skl\cpu000506E3_plat36_ver00000088_date#16-03-2016.bin) && goto start
if /I %ec%==0 exit
goto mn1

:start
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -o ..\..\..\temp\LGA1151.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtbn% -o ..\..\..\temp\LGA1151_BOOT_NO.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtby% -o ..\..\..\temp\LGA1151_BOOT_YES.ffs

exit