@echo off

title CPU IvyBridge/SandyBridge Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin
set mc_ivb=0
set mc_snb=0

if not exist IVBSNB (echo Error! Folder IVBSNB not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU IvyBridge (LGA1155)
echo.
echo 	7  Version  7 Date 11-21-2011
echo 	8  Version  8 Date 12-07-2011
echo 	0A Version 0A Date 01-06-2012
echo 	0C Version 0C Date 01-13-2012
echo 	0D Version 0D Date 02-06-2012
echo 	10 Version 10 Date 02-20-2012
echo 	12 Version 12 Date 04-12-2012
echo 	13 Version 13 Date 07-16-2012
echo 	15 Version 15 Date 08-07-2012
echo 	16 Version 16 Date 10-30-2012
echo 	17 Version 17 Date 01-09-2013
echo 	19 Version 19 Date 06-13-2013 - Best overclocking
echo 	1B Version 1B Date 05-29-2014
echo 	1C Version 1C Date 02-26-2015
echo 	0  Skip
echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1

if /I %ec%==7 (set mci=IVBSNB\cpu000306A9_plat12_ver00000007_date#21-11-2011.bin) && goto mn_snb
if /I %ec%==8 (set mci=IVBSNB\cpu000306A9_plat12_ver00000008_date#07-12-2011.bin) && goto mn_snb
if /I %ec%==0A (set mci=IVBSNB\cpu000306A9_plat12_ver0000000A_date#06-01-2012.bin) && goto mn_snb
if /I %ec%==0C (set mci=IVBSNB\cpu000306A9_plat12_ver0000000C_date#13-01-2012.bin) && goto mn_snb
if /I %ec%==0D (set mci=IVBSNB\cpu000306A9_plat12_ver0000000D_date#06-02-2012.bin) && goto mn_snb
if /I %ec%==10 (set mci=IVBSNB\cpu000306A9_plat12_ver00000010_date#20-02-2012.bin) && goto mn_snb
if /I %ec%==12 (set mci=IVBSNB\cpu000306A9_plat12_ver00000012_date#12-04-2012.bin) && goto mn_snb
if /I %ec%==13 (set mci=IVBSNB\cpu000306A9_plat12_ver00000013_date#16-07-2012.bin) && goto mn_snb
if /I %ec%==15 (set mci=IVBSNB\cpu000306A9_plat12_ver00000015_date#07-08-2012.bin) && goto mn_snb
if /I %ec%==16 (set mci=IVBSNB\cpu000306A9_plat12_ver00000016_date#30-10-2012.bin) && goto mn_snb
if /I %ec%==17 (set mci=IVBSNB\cpu000306A9_plat12_ver00000017_date#09-01-2013.bin) && goto mn_snb
if /I %ec%==19 (set mci=IVBSNB\cpu000306A9_plat12_ver00000019_date#13-06-2013.bin) && goto mn_snb
if /I %ec%==1B (set mci=IVBSNB\cpu000306A9_plat12_ver0000001B_date#29-05-2014.bin) && goto mn_snb
if /I %ec%==1C (set mci=IVBSNB\cpu000306a9_plat12_ver0000001C_date#26-02-2015.bin) && goto mn_snb
if /I %ec%==0 (set mc_ivb=1) && goto mn_snb
goto mn1

:mn_snb
set ec=
echo.
echo		Generate FFS files Microcode for CPU SandyBridge (LGA1155)
echo.
echo 	5  Version  5 Date 09-08-2010
echo 	6  Version  6 Date 09-15-2010
echo 	9  Version  9 Date 10-28-2010
echo 	0C Version 0C Date 11-17-2010
echo 	0D Version 0D Date 11-18-2010
echo 	12 Version 12 Date 12-28-2010
echo 	14 Version 14 Date 01-06-2011
echo 	17 Version 17 Date 04-07-2011
echo 	18 Version 18 Date 05-18-2011
echo 	1A Version 1A Date 06-21-2011
echo 	1B Version 1B Date 07-14-2011
echo 	23 Version 23 Date 08-28-2011
echo 	25 Version 25 Date 10-11-2011
echo 	26 Version 26 Date 01-25-2012
echo 	28 Version 28 Date 04-24-2012 - Best overclocking
echo 	29 Version 29 Date 06-12-2013
echo 	0  Skip
:mn2
set /p ec=Enter Microcode:
if not defined ec goto mn2

if /I %ec%==5 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000005_date#08-09-2010.bin) && goto mn_snb
if /I %ec%==6 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000006_date#15-09-2010.bin) && goto mn_snb
if /I %ec%==9 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000009_date#28-10-2010.bin) && goto mn_snb
if /I %ec%==0C (set mcs=IVBSNB\cpu000206A7_plat12_ver0000000C_date#17-11-2010.bin) && goto mn_snb
if /I %ec%==0D (set mcs=IVBSNB\cpu000206A7_plat12_ver0000000D_date#18-11-2010.bin) && goto mn_snb
if /I %ec%==12 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000012_date#28-12-2010.bin) && goto mn_snb
if /I %ec%==14 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000014_date#06-01-2011.bin) && goto mn_snb
if /I %ec%==17 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000017_date#07-04-2011.bin) && goto mn_snb
if /I %ec%==18 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000018_date#18-05-2011.bin) && goto mn_snb
if /I %ec%==1A (set mcs=IVBSNB\cpu000206A7_plat12_ver0000001A_date#21-06-2011.bin) && goto mn_snb
if /I %ec%==1B (set mcs=IVBSNB\cpu000206A7_plat12_ver0000001B_date#14-07-2011.bin) && goto mn_snb
if /I %ec%==23 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000023_date#28-08-2011.bin) && goto mn_snb
if /I %ec%==25 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000025_date#11-10-2011.bin) && goto mn_snb
if /I %ec%==26 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000026_date#25-01-2012.bin) && goto mn_snb
if /I %ec%==28 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000028_date#24-04-2012.bin) && goto start
if /I %ec%==29 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000029_date#12-06-2013.bin) && goto start
if /I %ec%==0 (set mc_snb=1) && goto start
goto mn2

:start
if %mc_ivb%==0 if %mc_snb%==0 GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mci% -i %mcs% -o ..\..\..\temp\LGA1155.ffs
if %mc_ivb%==0 if %mc_snb%==1 GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mci% -o ..\..\..\temp\LGA1155.ffs
if %mc_ivb%==1 if %mc_snb%==0 GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mcs% -o ..\..\..\temp\LGA1155.ffs

exit