@echo off

title CPU Broadwell-E Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin

if not exist hsw (echo Error! Folder HSW not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU Broadwell-E (LGA2011v3)
echo.
echo 	0B Version  0B Date 09-11-2015
echo 	0E Version  0E Date 10-30-2015
echo 	10 Version  10 Date 12-03-2015
echo 	11 Version  11 Date 12-10-2015
echo 	14 Version  14 Date 01-19-2016
echo 	19 Version  19 Date 03-17-2016
echo 	0  Exit
echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1
if /I %ec%==0B (set mc=bdwe\cpu000406F1_platEF_ver0B00000B_date#11-09-2015.bin) && goto start
if /I %ec%==0E (set mc=bdwe\cpu000406F1_platEF_ver0B00000E_date#30-10-2015.bin) && goto start
if /I %ec%==10 (set mc=bdwe\cpu000406F1_platEF_ver0B000010_date#03-12-2015.bin) && goto start
if /I %ec%==11 (set mc=bdwe\cpu000406F1_platEF_ver0B000011_date#10-12-2015.bin) && goto start
if /I %ec%==14 (set mc=bdwe\cpu000406F1_platEF_ver0B000014_date#29-01-2016.bin) && goto start
if /I %ec%==19 (set mc=bdwe\cpu000406F1_platEF_ver0B000019_date#17-03-2016.bin) && goto start
if /I %ec%==0 exit
goto mn1                        
:start
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -o ..\..\..\temp\LGA2011v3.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtbn% -o ..\..\..\temp\LGA2011v3_BOOT_NO.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtby% -o ..\..\..\temp\LGA2011v3_BOOT_YES.ffs

exit